#!/bin/sh
export PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin

echo ""
echo ""
echo "Starting Sim Bank Scheduler Server install "
echo ""
echo ""

if id | grep root > /dev/null
then
        :
else
        echo "You must be root to install these tools."
        exit 1
fi

if [ ! -d smb_scheduler ]
then
	echo "Please change smb_scheduler_install directory "
	exit 1
fi

echo "Configure httpd config:"
echo "Enter the httpd config file PATH: (default: /etc/httpd/conf.d)"
echo "Defautl press Enter"
read HTTP_PATH
if [ "${HTTP_PATH}" = "" ] 
then
	HTTP_PATH="/etc/httpd/conf.d"
fi

if [ ! -d ${HTTP_PATH} ]
then
	echo "${HTTP_PATH} do not exist"
	exit 1
fi

echo ""
echo ""


echo ""
echo ""
echo "Import Server Databases "
echo "Enter the Mysql root password if the password exist:"
read MYSQL_PW
if [ ${MYSQL_PW}1 = "1" ] 
then
	:
else
	 MY_PRA="-p${MYSQL_PW}"
fi

echo ""
echo ""
echo "Enter your Mysql PATH: (default: /usr/bin/mysql)"
echo "Defautl press Enter"
read MYSQL_PATH
if [ "${MYSQL_PATH}" = ""  ] 
then
	MYSQL_PATH="/usr/bin/mysql"
fi

${MYSQL_PATH} -u root $MY_PRA < smb_scheduler/scheduler.sql

if [ $? = "0" ]
then
	:
else
	echo "Mysql Database error"	
	exit 1
fi


echo '
Alias /smb_scheduler "/usr/local/smb_scheduler"
<Directory "/usr/local/smb_scheduler">
    Options FollowSymLinks Indexes MultiViews
    AllowOverride None
    Order allow,deny
    Allow from all
</Directory>
' > $HTTP_PATH/smb_scheduler.conf
echo "Copying file to /usr/local/smb_scheduler"
cp -r smb_scheduler /usr/local/
chmod -R 777 /usr/local/smb_scheduler

[ -f "/etc/conf.d/local.start" ] && local="/etc/conf.d/local.start";
[ -f "/etc/rc.d/rc.local" ] && local="/etc/rc.d/rc.local"
[ -f "/etc/rc.local" ] && local="/etc/rc.local"


rclocaltmp=`mktemp /tmp/rclocal.XXXXXXXXXX`

if grep -q "smb_scheduler" $local
then
        sed /smb_scheduler/d $local > $rclocaltmp
        cat $rclocaltmp > $local
        rm -f $rclocaltmp
fi

echo "/usr/local/smb_scheduler/run_scheduler" >>$local
/usr/local/smb_scheduler/run_scheduler

echo "Install finish."
echo "Please restart your httpd"
echo "Sim Bank Scheduler Server URL: http://your_ip/smb_scheduler"

