.TH "ZIP_SET_FILE_COMPRESSION" "3" "November 13, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_set_file_compression\fR
\- set compression method for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.PD 0
.HP 4n
\fBzip_set_file_compression\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_int32_t\ comp\fR, \fIzip_uint32_t\ comp_flags\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_set_file_compression\fR()
function sets the compression method for the file at position
\fIindex\fR
in the zip archive to
\fIcomp\fR
with the compression method specific
\fIcomp_flags\fR.
The
\fIcomp\fR
is the same as returned by
zip_stat(3).
For the
\fIcomp\fR
argument, currently only the following values are supported:
.TP 19n
\fRZIP_CM_DEFAULT\fR
default compression; currently the same as
\fRZIP_CM_DEFLATE\fR.
.TP 19n
\fRZIP_CM_STORE\fR
Store the file uncompressed.
.TP 19n
\fRZIP_CM_BZIP2\fR
Compress the file using the
bzip2(1)
algorithm.
.TP 19n
\fRZIP_CM_DEFLATE\fR
Deflate the file with the
zlib(3)
algorithm and default options
.PP
\fINOTE\fR:
Only the deflate and store methods can be assumed to be universally
supported.
.PP
The
\fIcomp_flags\fR
argument defines the compression level, 1 being fastest compression
and 9 highest.
Allowed values are 0 (which uses the default compression for the
algorithm) and 1-9, other values are undefined.
Further compression method specific flags might be added over time.
.PP
The current compression method for a file in a zip archive can be
determined using
zip_stat(3).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_set_file_compression\fR()
fails if:
.TP 19n
[\fRZIP_ER_COMPNOTSUPP\fR]
Unsupported compression method requested.
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR,
or the argument combination is invalid.
.TP 19n
[\fRZIP_ER_RDONLY\fR]
Read-only zip file, no changes allowed.
.SH "SEE ALSO"
libzip(3),
zip_stat(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
