/************************************************************************/
/*                                                                      */
/************************************************************************/


#include "FaxMonitor.h"
char mIniPath[MAX_PATH]; //·
char CmdLine[MAX_PATH];


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{

	HANDLE   hMutex=::CreateMutex(NULL,TRUE,"FaxMonitor_Mutex");
	if   (hMutex!=NULL)
	{
		if 
			(GetLastError()==ERROR_ALREADY_EXISTS)
		{  
		    MessageBoxA(0,"Ѿһ","ʹ",0);
		    return 0; 
		}
	}
	ZeroMemory(mIniPath,MAX_PATH);
	ZeroMemory(CmdLine,MAX_PATH);
	GetModuleFileName(NULL,mIniPath,MAX_PATH);
	PathRemoveFileSpec(mIniPath);
	strcpy_s(mIniPath+strlen(mIniPath),MAX_PATH,"\\faxmonitor.ini");
	strcpy_s(CmdLine,MAX_PATH,szCmdLine);
    char Url[MAX_PATH];
	ZeroMemory(Url,MAX_PATH);
	GetPrivateProfileString("","url","http://",
		Url,MAX_PATH,mIniPath); 
	
	if (0!=StrCmp(szCmdLine,"")&&0!=StrCmp(Url,""))
	{
		DialogBox(hInstance, MAKEINTRESOURCE(IDD_DLG_SEND), NULL, (DLGPROC)CSendDlg::WndProc);
	}
	else if (0!=StrCmp(szCmdLine,"")&&0==StrCmp(Url,""))
	{

		MessageBoxA(0,"Ƚ,ܷʹ","淢",0);
		if (!DeleteFile(CmdLine))
		{
			MessageBoxA(0,"ɾļʹ","ʹ",0);
		}
	}
	else
	{
		DialogBox(hInstance, MAKEINTRESOURCE(IDD_DLG_FAXMONITOR), NULL, (DLGPROC)CFaxMonitorDlg::WndProc);
	}
	return 0;
}

//ôڻص
LRESULT CALLBACK CFaxMonitorDlg::WndProc(HWND m_hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{    
	case WM_INITDIALOG:
		{
			char Account[MAX_PATH];
			char User[MAX_PATH];
			char Url[MAX_PATH];

			GetPrivateProfileString("","account","1000",
				Account,MAX_PATH,mIniPath); 
			GetPrivateProfileString("","user","admin",
				User,MAX_PATH,mIniPath); 
			GetPrivateProfileString("","url","http://",
				Url,MAX_PATH,mIniPath); 

			SetDlgItemText(m_hwnd,IDC_EDT_ACCOUNT,Account);
			SetDlgItemText(m_hwnd,IDC_EDT_URL,Url);
			SetDlgItemText(m_hwnd,IDC_EDT_USER,User);
		}
		break;

	case WM_COMMAND:
		switch(LOWORD( wParam ))
		{
		case IDOK:
			{
				int ret=CFaxMonitorDlg::OnBnClickedOk(m_hwnd);
			}
			break;
		case IDC_BTN_SAVE:
			{
				CFaxMonitorDlg::OnBnClickedBtnSave(m_hwnd);
			}
			break;
		};
		break;
	case WM_CLOSE:
		EndDialog(m_hwnd, 0 );
		break;
	};
	return 0;
}

//
int CFaxMonitorDlg::OnBnClickedOk(HWND m_hwnd)
{
	char Account[MAX_PATH];
	char User[MAX_PATH];
	char Url[MAX_PATH];
	char Password[MAX_PATH];
	GetDlgItemText(m_hwnd,IDC_EDT_ACCOUNT,Account,MAX_PATH);
	GetDlgItemText(m_hwnd,IDC_EDT_USER,User,MAX_PATH);
	GetDlgItemText(m_hwnd,IDC_EDT_URL,Url,MAX_PATH);
	GetDlgItemText(m_hwnd,IDC_EDT_PASSWORD,Password,MAX_PATH);
    
	std::string strUrl(Url);
	std::string strUser(User);
	std::string StrPassword(Password);
	phprpc::phprpc_client client(strUrl);
	std::vector<phprpc::any> Args;
	Args.push_back(strUser);
	Args.push_back(phprpc::md5::hex(StrPassword));
	phprpc::any Ret;
	int Statcode;
	try
	{
		Ret =client.invoke("base_clientlogin",&Args,true);
		phprpc::any_unordered_map *Arr = (phprpc::any_unordered_map *)(Ret);
		phprpc::any_unordered_map *Response = (phprpc::any_unordered_map *)(*Arr)["response"];
		Statcode=(int)(*Response)["statcode"];
		delete Arr;
		delete Response;
		switch (Statcode)
		{
		case 200:
			MessageBoxA(m_hwnd,"ӳɹ","",0);
			break;
		case 401:
			MessageBoxA(m_hwnd,"֤ʧ,û","",0);
			break;
		case 403:
			MessageBoxA(m_hwnd,"ֹ","",0);
			break;
		case 500:
			MessageBoxA(m_hwnd,"ڲ","",0);
			break;
		default:
			break;
		}

	}
	catch(phprpc::bad_any_cast&)
	{
		MessageBoxA(m_hwnd,"ӷ,RPCַ","",0);
		return -1;
	}

	return 0;
}
//
void  CFaxMonitorDlg::OnBnClickedBtnSave(HWND m_hwnd)
{

	char Account[MAX_PATH];
	char User[MAX_PATH];
	char Url[MAX_PATH];
	char Password[MAX_PATH];
	GetDlgItemText(m_hwnd,IDC_EDT_ACCOUNT,Account,MAX_PATH);
	GetDlgItemText(m_hwnd,IDC_EDT_USER,User,MAX_PATH);
	GetDlgItemText(m_hwnd,IDC_EDT_URL,Url,MAX_PATH);
	GetDlgItemText(m_hwnd,IDC_EDT_PASSWORD,Password,MAX_PATH);
	WritePrivateProfileString("","account",Account,mIniPath);
	WritePrivateProfileString("","url",Url,mIniPath);
	WritePrivateProfileString("","user",User,mIniPath);

	if (""==Password)
	{
		if((MessageBox(m_hwnd,"Ϊȷϱ?","ñ",4))==IDNO)   
		{   
			return;			
		}
	}
	std::string strPassword(Password);
	strPassword=phprpc::md5::hex(strPassword);
	WritePrivateProfileString("","Password",strPassword.c_str(),mIniPath);
	EndDialog(m_hwnd, 0);
	return;
}



//淢ʹڻص
LRESULT CALLBACK CSendDlg::WndProc(HWND m_hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{    
	case WM_INITDIALOG:
		{
			
		}
		break;
	case WM_COMMAND:
		switch(LOWORD( wParam ))
		{
		case IDOK:
			{
				int ret=CSendDlg::OnBnClickedOk(m_hwnd);
				
			}
			break;
		case IDCANCEL:
			{
				EndDialog(m_hwnd,0);
			}
			break;
	 	};
		break;
	case WM_CLOSE:
		EndDialog(m_hwnd,0);
		break;
	};
	return 0;
}
//淢Ͱť
int CSendDlg::OnBnClickedOk(HWND m_hwnd)
{

	char Account[MAX_PATH];
	char User[MAX_PATH];
	char Url[MAX_PATH];
	char Password[MAX_PATH];
	char Number[MAX_PATH];
	//ȡĿĵ绰
	GetDlgItemText(m_hwnd,IDC_EDT_NUMBER,Number,MAX_PATH);
	if (0==(StrCmp(Number,"")))
	{
		MessageBoxA(m_hwnd,"Ҵȥ,д","",0);
		return 0;
	}

    //ȡʹʹõķֻ
	ZeroMemory(Account,MAX_PATH);
	GetPrivateProfileString("","account","1000",
	Account,MAX_PATH,mIniPath); 
    //ȡRPC û
	ZeroMemory(User,MAX_PATH);
	GetPrivateProfileString("","user","admin",
	User,MAX_PATH,mIniPath); 
    //ȡRPC 
	ZeroMemory(Password,MAX_PATH);
	GetPrivateProfileString("","Password","",
	Password,MAX_PATH,mIniPath); 
    //ȡ RPC ַ
	ZeroMemory(Url,MAX_PATH);
	GetPrivateProfileString("","url","http://",
	Url,MAX_PATH,mIniPath); 
 
	//ļȡtff
	std::string FileBinary;
	wchar_t wstr[MAX_PATH];
	MultiByteToWideChar(CP_ACP, NULL, CmdLine, strlen(CmdLine) + 1, wstr, strlen(CmdLine) + 1);
	std::fstream ifs(wstr,std::ios::in|std::ios::binary);
	if (!ifs)
	{
		MessageBoxA(m_hwnd,",ļʧ","",0);
		EndDialog(m_hwnd,0);
		return 0;
	} 
	ifs.seekg(0, std::ios::end);
	int size = (int)ifs.tellg();
	ifs.seekg(0, std::ios::beg);
	char *Buf=new char[size];
	ZeroMemory(Buf,size);
	ifs.read(Buf,size);
	FileBinary.assign(Buf,Buf+size);
	delete [] Buf;
	ifs.close();
 	if (!DeleteFile(CmdLine))
	{
     MessageBoxA(m_hwnd,"ɾļʹ","ʹ",0);
	}

	std::string strUrl(Url);
	phprpc::phprpc_client Client(strUrl);
	std::vector<phprpc::any> Args;    //֤ݵĲ
	std::vector<phprpc::any> Args_fax; //
	std::string strUser(User);
	std::string strPassword(Password);
	Args.push_back(strUser);
	Args.push_back(strPassword);
	phprpc::any Ret;
	int StatCode=0;
	try
	{
		Ret =Client.invoke("base_clientlogin",&Args,true);
		phprpc::any_unordered_map *Arr = (phprpc::any_unordered_map *)(Ret);
		phprpc::any_unordered_map *Response = (phprpc::any_unordered_map *)(*Arr)["response"];
		StatCode=(int)(*Response)["statcode"];
		if (StatCode==200)
		{
			std::string strAccount(Account);
			std::string strNumber(Number);
			Args_fax.push_back(strAccount);
			Args_fax.push_back(strNumber);
			Args_fax.push_back("tiff");
			Args_fax.push_back(FileBinary);
			Args_fax.push_back(3);
			Ret=Client.invoke("fax_faxfile_send",&Args_fax,true);
			Arr = (phprpc::any_unordered_map *)(Ret);
			Response = (phprpc::any_unordered_map *)(*Arr)["response"];
			StatCode=(int)(*Response)["statcode"];
			switch (StatCode)
			{
			case 200:
				MessageBoxA(m_hwnd,"ʹɹ","ʹ",0);
				break;
			case 401:
				MessageBoxA(m_hwnd,"֤ʧ,û","ʹ",0);
				break;
			case 403:
				MessageBoxA(m_hwnd,"ֹ","ʹ",0);
				break;
			case 500:
			    MessageBoxA(m_hwnd,"ڲ","ʹ",0);
				break;
			default:
				break;
			}
			
		}
		else
		{
			 MessageBoxA(m_hwnd,"֤ʧ","ʹ",0);
		}
		delete Arr;
		delete Response;
	    EndDialog(m_hwnd,0);
		return 0;
	}
	catch(phprpc::bad_any_cast&)
	{
		MessageBoxA(m_hwnd,"ӷ","ʹ",0);
		EndDialog(m_hwnd,0);
		return 0;
	}

    EndDialog(m_hwnd,0); 
	return 0;
}